#version 330
#extension GL_EXT_gpu_shader4 : enable
// Gingham VortexMod01.fsh  by   isohedral

//https://www.shadertoy.com/view/td33RN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float TWOPI = 2.0*3.14159265358979;
const float fac = 10.0 / TWOPI;

// 240, 23, 24
// 246, 128, 126
// 255, 255, 255

vec2 eval( vec2 p, vec2 c, float strength )
{
    p -= c;
    float l = log( length( p ) );
    float ang = atan( p.y, p.x );
    return strength * vec2( l, ang );
}

vec4 getColour( vec2 sp )
{
    vec2 p = 3.*(2.*sp - iResolution.xy) / iResolution.x;

    vec2 ep = eval( p, vec2( -1.5, 1 ), 1.0 ) 
        + eval( p, vec2( 1.5, -1 ), 1.0 )
        + eval( p, vec2( -1.5, -1 ), -1.0 )
        + eval( p, vec2( 1.5, 1 ), -1.0 );
    float d = fwidth(ep).x * 4.*fac;
    ep = ep + 4.*vec2(-ep.y,ep.x);
	vec2 si = smoothstep(-.5*d,.5*d,abs(mod(fac*ep + iTime*0.75,2.)-1.)-.5);  

    return 1.- (1.-vec4(1,.5,.5,0)) * (si.x+si.y);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
    gl_FragColor = getColour( gl_FragCoord.xy );
}